DROP PROCEDURE IF EXISTS sp_insertUpdateProveedor;

delimiter $
CREATE DEFINER=`targoxco`@`localhost` PROCEDURE sp_insertUpdateProveedor(
	IN p_idProveedor INT, IN p_idRubro INT, IN p_idEstado INT, IN p_idPais VARCHAR(2), IN p_idCiudad INT, 
    IN p_nombreEmpresa VARCHAR(300), IN p_nombreComercial VARCHAR(300), IN p_ruc VARCHAR(11), 
    IN p_direccion VARCHAR(300), IN p_referencia VARCHAR(300),
    IN p_cuentaInstagram VARCHAR(300), IN p_cuentaFacebook VARCHAR(300),
    IN p_telefono1 VARCHAR(12), IN p_telefono2 VARCHAR(12), IN p_telefono3 VARCHAR(12), 
    IN p_email VARCHAR(50), IN p_usuario VARCHAR(50), IN p_activo int)
BEGIN      
    IF EXISTS(SELECT idProveedor FROM PROVEEDOR WHERE ruc = p_ruc and idProveedor != p_idProveedor) THEN
		SELECT 0 as tipoRespuesta, 'Ya existe un proveedor con este ruc.' as respuesta, 0 as idProveedor;
    ELSE
		IF p_idProveedor = 0 THEN
			INSERT INTO PROVEEDOR (idRubro, idEstado, idPais, idCiudad, nombreEmpresa, nombreComercial, ruc, direccion, 
					referencia, cuentaInstagram, cuentaFacebook,
					telefono1, telefono2, telefono3, email,
					usuarioRegistro, fechaRegistro, pcRegistro,  activo )
			VALUES ( p_idRubro, p_idEstado, p_idPais, p_idCiudad, p_nombreEmpresa, p_nombreComercial, p_ruc, p_direccion,
				p_referencia, p_cuentaInstagram, p_cuentaFacebook,
                p_telefono1, p_telefono2, p_telefono3, p_email,
                NOW(), p_usuario, '', 1);
            
			SELECT 1 as tipoRespuesta, 'El proveedor se registró correctamente' as respuesta, last_insert_id() as idProveedor;
        ELSE
			UPDATE PROVEEDOR
            SET 
				idRubro = p_idRubro, idEstado = p_idEstado, idPais = p_idPais, idCiudad = p_idCiudad, 
                nombreEmpresa = p_nombreEmpresa, nombreComercial = p_nombreComercial, ruc = p_ruc, direccion = p_direccion, 
				referencia = p_referencia, cuentaInstagram = p_cuentaInstagram, cuentaFacebook = p_cuentaFacebook,
                telefono1 = p_telefono1, telefono2 = p_telefono2, telefono3 = p_telefono3, 
                email = p_email, usuarioEdicion = p_usuario, fechaEdicion = NOW(), pcEdicion = '-',
                activo = p_activo
            WHERE idProveedor = p_idProveedor;
            
            UPDATE CONTACTO
            SET Activo = 0
            WHERE idProveedor = p_idProveedor;
            
            SELECT 1 as tipoRespuesta, 'El proveedor se editó correctamente' as respuesta, p_idProveedor as idProveedor;
        END IF;
    END IF;
    
    
    -- SELECT  CONCAT(COLUMN_NAME, ','), COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, IS_NULLABLE, COLUMN_DEFAULT
	-- FROM INFORMATION_SCHEMA.COLUMNS	  WHERE table_name = 'PROVEEDOR'  AND table_schema = 'erp_targox';
END
$